
**TABLE CODING**

*The data used to generate these tables are confidential and are not provided. Further manipulation of data sometimes required after export.

ssc install tabout
ssc install tablecol



* Table 1
* Title: Consumer Payment Methods
* Subtitle: Share of all payments

* Code
use "", clear

* TOP: BY NUMBER CONSUMER PAYMENT METHODS
tablecol paymethcons3 year [pw=dweight] if paymeth >= 0 & payamt >= 0 & payamt < 9999, nofreq colpct
quietly: tabout paymethcons3 year [iw=dweight] if paymeth >= 0 & payamt >= 0 & payamt < 9999 using "Table 1.xls",  clab(LHS) format(4) cell(col) replace

* BOTTOM: BY VALUE CONSUMER PAYMENT METHODS
table paymethcons3 year [pw=dweight] if paymeth >= 0 & payamt >= 0 & payamt < 9999, c(sum payamtr)
quietly: tabout paymethcons3 year [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt < 9999 using "Table 1.xls", clab(RHS) sum c(sum payamtr) format(4) append



* Table 2
* Title: Cash and Card Payments by Demographic Groups
* Subtitle: Per cent of number of payments by respondents in each group

* Code
use "", clear

* Top panel - by age
tablecol agebin paymethcons2 [pw=dweight] if paymeth>=0 & payamt>=0 & payamt<9999, rowpct nofreq by(year)
quietly: tabout agebin paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2007 using "Table 2.xls", c(row) f(4) clab(2007) replace
quietly: tabout agebin paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2010 using "Table 2.xls", c(row) f(4) clab(2010) append
quietly: tabout agebin paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2013 using "Table 2.xls", c(row) f(4) clab(2013) append
quietly: tabout agebin paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2016 using "Table 2.xls", c(row) f(4) clab(2016) append
quietly: tabout agebin paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2019 using "Table 2.xls", c(row) f(4) clab(2019) append

 * Middle panel - by age-adjusted hh income
tablecol agehhincq paymethcons2 [pw=dweight] if paymeth>=0 & payamt>=0 & payamt<9999, rowpct nofreq by(year)
quietly: tabout agehhincq paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2007 using "Table 2.xls", c(row) f(4) clab(2007) append
quietly: tabout agehhincq paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2010 using "Table 2.xls", c(row) f(4) clab(2010) append
quietly: tabout agehhincq paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2013 using "Table 2.xls", c(row) f(4) clab(2013) append
quietly: tabout agehhincq paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2016 using "Table 2.xls", c(row) f(4) clab(2016) append
quietly: tabout agehhincq paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2019 using "Table 2.xls", c(row) f(4) clab(2019) append

 * Bottom panel - by location
tablecol region paymethcons2 [pw=dweight] if paymeth>=0 & payamt>=0 & payamt<9999 & region>=0, rowpct nofreq by(year)
quietly: tabout region paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & region>=0 & year==2007 using "Table 2.xls", c(row) f(4) clab(2007) append
quietly: tabout region paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & region>=0 & year==2010 using "Table 2.xls", c(row) f(4) clab(2010) append
quietly: tabout region paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & region>=0 & year==2013 using "Table 2.xls", c(row) f(4) clab(2013) append
quietly: tabout region paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & region>=0 & year==2016 using "Table 2.xls", c(row) f(4) clab(2016) append
quietly: tabout region paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & region>=0 & year==2019 using "Table 2.xls", c(row) f(4) clab(2019) append



* Table 3
* Title: Cash Top-ups by Source
* Subtitle: .

* Code
use "", clear

* share of respondents
egen topupnum=sum(topupmeth>0), by(id)
replace topupnum=1 if topupnum>0
tablecol topupnum year if idtag==1 [pw=dweight], colpct
quietly: tabout topupnum year [aw=dweight] if idtag==1 using "Table 3.xls", c(col) format(4) replace

* number per person by method
tablecol topupmeth year [pw=dweight] if topupmeth>-1, row
quietly: tabout topupmeth year [iw=dweight] if topupmeth>-1 using "Table 3.xls", format(4) append

* median value
table topupmeth year [pw=dweight] if topupmeth>-1 & topupamt>0, c(median topupamt) row
quietly: tabout topupmeth year [aw=dweight] if topupmeth>-1 & topupamt>0 using "Table 3.xls", format(4) sum c(median topupamt) clab(median) append

* ATM fees
tablecol atmfee year [pw=dweight] if topupmeth==1 & atmfee>=0, colpct
quietly: tabout atmfee year [aw=dweight] if topupmeth==1 & atmfee>=0 using "Table 3.xls", format(4) c(col) append



* Table 4
* Title: Cash and Card Payments for Different Types of Purchases
* Subtitle: Share of number of payments

* Code
use "", clear

** TABLE 4 - Cash and Card Payments by Amount and Merchant Type
 * Top panel - by payment amount
tablecol payamtbinr paymethcons2 [pw=dweight] if paymeth>=0 & payamt>=0 & payamt<9999, rowpct nofreq by(year)


quietly: tabout payamtbinr paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2007 using "Table 4.xls", c(row) f(4) clab(2007) replace
quietly: tabout payamtbinr paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2010 using "Table 4.xls", c(row) f(4) clab(2010) append
quietly: tabout payamtbinr paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2013 using "Table 4.xls", c(row) f(4) clab(2013) append
quietly: tabout payamtbinr paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2016 using "Table 4.xls", c(row) f(4) clab(2016) append
quietly: tabout payamtbinr paymethcons2 [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2019 using "Table 4.xls", c(row) f(4) clab(2019) append


**Bottom - by merchant category
quietly: tabout paypurpcons2 paymethcons2 [aw=dweight] if paypurp >0 & paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2007 using "Table 4.xls", c(row) f(4) clab(2007) append
quietly: tabout paypurpcons2 paymethcons2 [aw=dweight] if paypurp >0 & paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2010 using "Table 4.xls", c(row) f(4) clab(2010) append
quietly: tabout paypurpcons2 paymethcons2 [aw=dweight] if paypurp >0 & paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2013 using "Table 4.xls", c(row) f(4) clab(2013) append
quietly: tabout paypurpcons2 paymethcons2 [aw=dweight] if paypurp >0 & paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2016 using "Table 4.xls", c(row) f(4) clab(2016) append
quietly: tabout paypurpcons2 paymethcons2 [aw=dweight] if paypurp >0 & paymeth >= 0 & payamt >= 0 & payamt <9999 & year==2019 using "Table 4.xls", c(row) f(4) clab(2019) append





* Table 5
* Title: Card Surcharges Paid - 2019
* Subtitle: .

* Code
use "", clear

gen cardsurchdolcom=-1
replace cardsurchdolcom=cardsurchdol if cardsurchdol>=0 
replace cardsurchdolcom=cardsurchamtp*payamt/100 if !(cardsurchdol>=0) & cardsurchamtp>=0 & payamt>=0 & (cardsurchamtp*payamt/100)>0

replace cardsurchdolcom=-1 if inlist(cardsurchamtp,10,100) 
replace cardsurchamtp=-1 if inlist(cardsurchamtp,10,100)

summarize cardsurchdolcom if  cardsurchdolcom>0 [aw=weight], detail
summarize cardsurchdolcom if  cardsurchdolcom>0 [aw=weight], detail

summarize cardsurchamtp if  cardsurchamtp>0 [aw=weight], detail
summarize cardsurchamtp if  cardsurchamtp>0 [aw=weight], detail

gen surchdummy=-1
replace surchdummy=0 if paymethcons2==2
replace surchdummy=1 if surchdummy==0 & cardsurchamtp>0 & paymethcons2==2

tab surchdummy  if surchdummy>=0 & payamt>=0 & payamt<9999 [iw=weight]


***
tablecol paymethcons surchdummy [pw=weight] if payment==1 & inlist(paymethx,2,3,4) & surchdummy>=0 & !inlist(paypurp,17,18,19) & payamt<9999 & payamt>=0, nofreq rowpct
tablecol paymethcons surchdummy [pw=weight] if payment==1 & inlist(paymethx,2,3,4) & !inlist(paypurp,17,18,19) & payamt<9999 & payamt>=0 & paymeth != 11, nofreq rowpct
tablecol paymethcons2 surchdummy [pw=weight] if payment==1 & inlist(paymethx,2,3,4) & !inlist(paypurp,17,18,19) & payamt<9999 & payamt>=0 & paymeth != 11, nofreq rowpct

**tabout by paymethcons
quietly: tabout paymethcons surchdummy [aw=weight] if paymeth != 11 & payment==1 & inlist(paymethx,2,3,4) & surchdummy>=0 & !inlist(paypurp,17,18,19) & payamt<9999 & payamt>=0 using "Table 5.xls", replace  format(4) cell(row)
**tabout by reward status
tablecol ccreward surchdummy [pw=weight] if payment==1 & inlist(paymethx,3,4) & !inlist(paypurp,17,18,19) & payamt<9999 & payamt>=0 & paymeth != 11, nofreq rowpct

quietly: tabout ccreward surchdummy [aw=weight] if paymeth != 11 & payment==1 & inlist(paymethx,3,4) & surchdummy>=0 & !inlist(paypurp,17,18,19) & payamt<9999 & payamt>=0 using "Table 5.xls", append  format(4) cell(row)

**tabout by payment channel
quietly: tabout payinper surchdummy [aw=weight] if paymeth != 11 & payment==1 & inlist(paymethx,2,3,4) & surchdummy>=0 & !inlist(paypurp,17,18,19) & payamt<9999 & payamt>=0 using "Table 5.xls", append  format(4) cell(row)

quietly: tabout paychan surchdummy [aw=weight] if paymeth != 11 & payment==1 & inlist(paymethx,2,3,4) & inlist(paychan,5,6) & surchdummy>=0 & !inlist(paypurp,17,18,19) & payamt<9999 & payamt>=0 using "Table 5.xls", append  format(4) cell(row)




* Table 6
* Title: Online Payments
* Subtitle: .

* Code
use "", clear


replace paychan =1 if year ==2019 & inlist(paychanx,1,2,3,4)
replace paychan =1 if year ==2019 & paymeth == 1

*first change paychan for 2019 to online or smartphone
replace paychan = 2 if paychan2019 == 6 & year == 2019
replace paychan = 3 if paychan2019 == 5 & year == 2019
***add offline into mail although not used for this purpose
replace paychan = 5 if paychan2019 == 7 & year == 2019


**************TABLE - ONLINE BY NUMBER AND VALUE
table paychan year [pw=dweight] if paychan>0 & payamt>= 0 & payamt<9999, c(sum payamt) row
tablecol paychan year [pw=dweight] if paychan>0 & payamt>= 0 & payamt<9999, nofreq colpct row

tablecol paychan year [pw=dweight] if inlist(paychan,2,3) & payamt>= 0 & payamt<9999, nofreq colpct row

*****STEP 1 - GET THE NUMBER AND  VALUE OF DIARY PAYMENTS (and weight by nweight, which is normalised by total respondents in both the auto and non-auto datasets)

***By number and then by value
quietly: tabout paychan year [aw=nweight] if paychan>0 & payamt>= 0 & payamt<9999  using "Table 6.xls",  clab(Table_6_num%) format(4) cell(freq)  replace
quietly: tabout paychan year [aw=nweight] if paychan>0 & payamt>= 0 & payamt<9999  using "Table 6.xls",  clab(Table_6_val%) format(4) sum c(sum payamt)  append

use "", clear

******** Step2. GET THE NUMBER AND VALUE OF AUTOMATIC PAYMENTS (and weight by nweight, which is normalised by total respondents in both the auto and non-auto datasets)
quietly: tabout autopurp year    if inweek==1 & autopurp>0  [aw=nweight] using "Table 6.xls",  clab(Table_6_autonum%) format(4) cell(freq)  append 
quietly: tabout autopurp year    if inweek==1 & autopurp>0  [aw=nweight] using "Table 6.xls",  clab(Table_6_autoval%) format(4) sum c(sum autoamt)  append 

